<?php
if ( home_services_set_pro_active() ) {
	if(get_theme_mod('home_services_latest_post_show_hide') ){?>
		<div class="latest-post-wraper home-block">
			<div class="container">
				<div class="row lastet-post-header">
					<div class="col-sm-8">
						<?php 
							if(get_theme_mod('home_services_lastest_heading_text')){
								echo '<h2>'.esc_html(get_theme_mod('home_services_lastest_heading_text')).'</h2>';
							}
							if(get_theme_mod('home_services_lastest_post_section_desc')){
								echo '<p>'.esc_html(get_theme_mod('home_services_lastest_post_section_desc')).'</p>';
							}
						?>
					</div>
					<div class="col-sm-4">
						<?php 
							$more_recent_button_link ='';
							if(get_theme_mod('home_services_lastest_view_all_button_link')){
								$more_recent_button_link =get_theme_mod('home_services_lastest_view_all_button_link');
							}
						?>
						<div class="button-group">
							<a class="btn" href="<?php  echo esc_url($more_recent_button_link);?>"><?php echo esc_html(get_theme_mod('home_services_lastest_view_all_button_text'));?></a>
						</div>
					</div>
				</div>
				<div class="row latest-post-list">
					<div class="latest-post-holder-wraper">
						<?php
			          
			           $post_args = array(
						        'post_type'				=> 'post',
						  		'post_status'    => 'publish',
						        'order'					=> 'DESC',
						        'posts_per_page'	 		=> 3,
						        'ignore_sticky_posts' => 1
						    );
						$post_query = new WP_Query( $post_args );
						 
		                if ( $post_query->have_posts() ) :
		                while( $post_query->have_posts() ):$post_query->the_post();?>
		                <div class="post-holder">
		                    <?php if(has_post_thumbnail()){
		                    	$summary_sub_class= 'with-thumbnails';?>
		                    	<div class="img-holder">
			                       <?php $image_url = wp_get_attachment_image_src(get_post_thumbnail_id(),'');?>
			                    	<a href="<?php the_permalink();?>">	<img width="465" height="371" src="<?php echo esc_url($image_url[0]); ?>"
			                        class="attachment-full size-full wp-post-image" alt="" loading="lazy"></a>
		                        </div>
		                    <?php } else{
		                    	$summary_sub_class= 'without-thumbnails';
		                    }?>
			                
			                <div class="summary <?php echo $summary_sub_class;?>">
			                	<div class="entry-meta category">
                                    <?php
                                        $categories = get_the_category();
                                      if( ! empty( $categories ) ) :
                                        foreach ( $categories as $category ) { ?>
                                            <span class="post-meta author-categories"><a
                                                href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><?php echo esc_html( $category->name ); ?></a>
                                            </span>
                                            <?php }
                                     endif; 
                                    ?>
                                </div>
			                    <h3 class="post-title">
			                    	<a href="<?php the_permalink();?>"><?php the_title(); ?></a>
			                    </h3>
			                    <div class="entry-meta after-title">
                                <?php
                                echo  '<span class="post-meta author-author">';
                                    home_services_posted_by();
                                echo '</span>';
                                
                                         $archive_year  = get_the_time('Y'); $archive_month = get_the_time('m'); $archive_day = get_the_time('d'); ?>
                                        <span class="post-meta author-post-date"> <a
                                                href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php echo get_the_date(); ?></a>
                                        </span>
                                        <span class="post-meta author-comment">
                                                <?php comments_popup_link( __( 'Leave a comment', 'home-services' ), __( '1 comment', 'home-services' ), __( '% comments', 'home-services' ) ); ?>
                                        </span>
                                        
                                      <?php $tags = get_the_tags($post->ID);
                                        if( ! empty( $tags ) ) :
                                            foreach ( $tags as $post_tag ) { ?>
                                                <span class="post-meta author-tag"><a
                                                            href="<?php echo esc_url( get_category_link( $post_tag->term_id ) ); ?>"><?php echo esc_html( $post_tag->name ); ?></a>
                                                </span>
                                         <?php }
                                     endif;
                                        ?>
                            </div><!-- .entry-meta -->
			                   <p class="short-info"><?php echo esc_html(home_services_excerpt( 25 )); ?></p>
			                   <a href="<?php the_permalink();?>" class="post-more">
			                   	<?php 
			                   		if(get_theme_mod('home_services_lastest_read_more_button_text')){
			                   			$post_details_btn_text= get_theme_mod('home_services_lastest_read_more_button_text');
			                   		}else{
			                   			$post_details_btn_text =__('Read More','home-services');
			                   		}
			                   	?>
			                   	<?php echo esc_html($post_details_btn_text);?> →
			                   </a>

			                </div>
			            </div>
				       
			            <?php
							endwhile;
			                wp_reset_postdata();  
			            endif;?>
			        </div>
				</div>
			</div>
		</div><!-- end of promotion-->
	<?php }
}?>