<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package home_services
 */

get_header();
$layout = get_theme_mod( 'single_blog_post_layout','single-sidebar-right');
if($layout=='single-no-sidebar'){
    $main_content_class='col-sm-12';
}else{
     $main_content_class='col-sm-8';
}
?>


<div class="inside-page content-area">
    <div class="container">
        <div class="row">
            <?php if($layout =='single-sidebar-left'){?>
                <div class="col-sm-4 single-post-sidebar"><?php get_sidebar(); ?></div>
            <?php } ?>
            <div class="<?php echo esc_attr($main_content_class);?>" id="main-content">
                <section class="page-section" id="primary">
                    <div class="detail-content">

                        <?php while ( have_posts() ) : the_post(); ?>
                        <?php get_template_part( 'template-parts/content', 'single' ); ?>
                        <?php endwhile; // End of the loop. ?>
                        <?php comments_template(); ?>

                    </div><!-- /.end of deatil-content -->
                    <?php $home_services_related_post_status = get_theme_mod('single_post_disable_related_post','true');
                    if($home_services_related_post_status){
                        
                        if($layout =='single-no-sidebar'){
                            $related_post_count= 3;
                            $column_class='col-sm-4';
                        }else{
                            $related_post_count= 2;
                            $column_class='col-sm-6';
                        }
                        ?>
                    <div class="related-posts">
                        <?php
                        $args = array (
                            'posts_per_page' => $related_post_count,
                            'post_type' => 'post',
                            'category__in' => wp_get_post_categories($post->ID),
                            'post__not_in' => array($post->ID)
                        );
                         
                        // run the query
                        $query = new WP_Query( $args ); 
                        if( $query->have_posts() ) {
                    ?>
                        <h2 class="title"><?php echo esc_html__( 'Related Posts', 'home-services' )?></h2>
                        <div class="row">
                        <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                            <div class="<?php echo esc_attr($column_class);?>">
                                <div class="news-snippet">
                                     <?php if ( has_post_thumbnail() ) : ?>
                                            <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark" class="featured-image">
                                             <?php the_post_thumbnail( 'home_services_feature_image' ); ?>
                                        </a>
                                     <?php endif; ?>
                                    <div class="summary">
                                        <div class="entry-meta category">
                                            <?php
                                                $categories = get_the_category();
                                              if( ! empty( $categories ) ) :
                                                foreach ( $categories as $category ) { ?>
                                                    <span class="post-meta author-categories"><a
                                                        href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><?php echo esc_html( $category->name ); ?></a>
                                                    </span>
                                                    <?php }
                                             endif; 
                                            ?>
                                        </div>
                                        <h4 class="news-title">
                                            <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark">
                                                <?php the_title(); ?>
                                            </a>
                                        </h4>
                                       <p><?php echo esc_html(home_services_excerpt( 20 )); ?></p>
                                        <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark" title=""
                                            class="readmore"><?php esc_html_e('Read More','home-services'); ?> &#8594; </a>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; the_posts_navigation(); ?>
                        <?php wp_reset_postdata(); ?>
                        </div>
                        <?php } ?>
                    </div>
                <?php } ?>
                </section> <!-- /.end of section -->
            </div>
            <?php if($layout =='single-sidebar-right'){?>
                <div class="col-sm-4 single-post-sidebar"><?php get_sidebar(); ?></div>
            <?php } ?>

        </div>
    </div>
</div>

<?php
get_footer();