<?php

/**
 * Form style for Conatct Form 7
 *
 * @package home_services
 */
add_action( 'customize_register', 'home_services_customize_social_media' );

function home_services_customize_social_media( $wp_customize ) {

    $wp_customize->add_section( 'abt_social_media_sections', array(
        'title'          => esc_html__( 'Social Media', 'home-services' ),
        'description' => esc_html__('Social Media Section :', 'home-services'),
        'priority'       => 13,
        'panel'          => 'home_service_header_settings',
       
    ) );
    
    $wp_customize->add_setting( 'abt_fb_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_fb_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'Facebook URL', 'home-services' ),
        'description' => __( 'This is a custom url input.','home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.google.com','home-services' ),
    ),
    ) );
    $wp_customize->add_setting( 'abt_fb_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_fb_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'Facebook URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.facebook.com','home-services' ),
    ),
    ) );
    $wp_customize->add_setting( 'abt_twitter_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_twitter_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'Twitter URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.twitter.com','home-services' ),
    ),
    ) );
    $wp_customize->add_setting( 'abt_instagram_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_instagram_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'Instagram URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.instagram.com','home-services' ),
    ),
    ) );
    $wp_customize->add_setting( 'abt_linkedin_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_linkedin_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'LinkedIn URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.linkedin.com','home-services' ),
    ),
    ) );

    $wp_customize->add_setting( 'abt_youtube_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_youtube_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'Youtube URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.youtube.com','home-services' ),
    ),
    ) );

    $wp_customize->add_setting( 'abt_home_advisor_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_home_advisor_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'Home Advisor URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.homeadvisor.com','home-services' ),
    ),
    ) );

    
    $wp_customize->add_setting( 'abt_bbb_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_bbb_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'BBB URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.bbb.com','home-services'),
    ),
    ) );

    $wp_customize->add_setting( 'abt_yelp_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_yelp_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'Yelp URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.yelp.com', 'home-services'),
    ),
    ) );

    $wp_customize->add_setting( 'abt_angies_list_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_angies_list_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'Angies List  URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://www.angieslist.com' ,'home-services'),
    ),
    ) );

    $wp_customize->add_setting( 'abt_google_my_business_url_setting_id', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'home_services_sanitize_url',
    ) );
  
    $wp_customize->add_control( 'abt_google_my_business_url_setting_id', array(
        'type' => 'url',
        'section' => 'abt_social_media_sections', // Add a default or your own section
        'label' => __( 'Google My Business URL', 'home-services' ),
        'input_attrs' => array(
        'placeholder' => __( 'http://googlemybusiness.com','home-services'),
    ),
    ) );
    
  function home_services_sanitize_url( $url ) {
    return esc_url_raw( $url );
  }

}
