<?php
/**
 * Drag & Drop Sections
 *
 * @package Home Services
 */
add_action( 'customize_register', 'home_services_sections_sortable' );

function home_services_sections_sortable( $wp_customize ) {
	if ( home_services_set_pro_active() ) {
		$wp_customize->add_section( 'home_services_sort_homepage_sections', array(
		    'title'          => esc_html__( 'Re-order Sections', 'home-services' ),
		    'panel'          => 'home_service_frontpage_settings',
		    'priority'       =>1,
		) );
		$default = array( 'services', 'promotions', 'about', 'wws', 'testimonial','teams','latestpost','newsletter', 'cta');

		$choices = array(
			'services' => esc_html__( 'Services', 'home-services' ),
			'promotions' => esc_html__( 'Promotions', 'home-services' ),
			'about' => esc_html__( 'About Us', 'home-services' ),
			'wws' => esc_html__( 'Extra Services', 'home-services' ),
			'testimonial' => esc_html__( 'Testimonials', 'home-services' ),
			'teams' => esc_html__( 'Team', 'home-services' ),
			'latestpost' => esc_html__( 'Latest Post', 'home-services' ),
			'newsletter' => esc_html__( 'Newsletter', 'home-services' ),
			'cta' => esc_html__( 'CTA', 'home-services' ),
		);
		
		
		$wp_customize->add_setting( 'home_services_sort_homepage', array(
	        'capability'  => 'edit_theme_options',
	        'sanitize_callback'	=> 'home_services_sanitize_array',
	        'default'     => $default
	    ) );

	    $wp_customize->add_control( new Home_Services_Control_Sortable( $wp_customize, 'home_services_sort_homepage', array(
	        'label' => esc_html__( 'Drag and Drop Sections to Rearrange.', 'home-services' ),
	        'section' => 'home_services_sort_homepage_sections',
	        'settings' => 'home_services_sort_homepage',
	        'type'=> 'home-services-sortable',
	        'choices'     => $choices
	    ) ) );
	}

}