<?php

/**
 * footer Fonts Settings
 *
 * @package home_services
 */


add_action( 'customize_register', 'home_services_customize_register_footer_options_section' );
function home_services_customize_register_footer_options_section( $wp_customize ) {
    $wp_customize->add_panel( 'home_service_footer_settings', 
        array(
            'priority'       => 18,
            'capability'     => 'edit_theme_options',
            'title'      =>  esc_html__('Footer Options', 'home-services'),
        ) 
    );

    $wp_customize->add_section( 'home_services_customize_register_footer_options_section', array(
        'title'          => esc_html__( 'Copyright Text', 'home-services' ),
        'priority'       => 1,
        'panel'          => 'home_service_footer_settings',    
    ) );

    
    $wp_customize->add_section( 'home_services_customize_register_mobile_cta', array(
        'title'          => esc_html__( 'Mobile CTA', 'home-services' ),
        'priority'       => 2,
        'panel'          => 'home_service_mobile_optimization_settings',    
    ) );

    
    if ( home_services_set_pro_active() ) {

    $wp_customize->add_setting( 'footer_color_scheme_option', array(
        'default' => '',
        'type' => 'home-services-customtext',
        'capability' => 'edit_theme_options',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( new Home_Services_Custom_Text( $wp_customize, 'footer_color_scheme_option', array(
        'label' => esc_html__( 'Footer Color', 'home-services' ),
        'section' => 'colors',
        'settings' => 'footer_color_scheme_option',
    ) ) );
        $wp_customize->add_setting( 'footer_background_color',
            array(
                'default'     => '#f4f5f7',
                'transport'   => 'refresh',
                'sanitize_callback' => 'home_services_sanitize_hex_color'
            )
        );

        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 
            'footer_background_color', 
                array(
                    'label'      => esc_html__( 'Background Color', 'home-services' ),
                    'section'    => 'colors',
                    'settings'   => 'footer_background_color',
                ) 
            ) 
        );
        $wp_customize->add_setting( 'footer_text_color',
            array(
                'default'     => '#000000',
                'transport'   => 'refresh',
                'sanitize_callback' => 'home_services_sanitize_hex_color'
            )
        );

        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 
            'footer_text_color', 
                array(
                    'label'      => esc_html__( 'Text Color', 'home-services' ),
                    'section'    => 'colors',
                    'settings'   => 'footer_text_color',
                ) 
            ) 
        );

        $wp_customize->add_setting( 'footer_link_hover_color',
            array(
                'default'     => '#05398e',
                'transport'   => 'refresh',
                'sanitize_callback' => 'home_services_sanitize_hex_color'
            )
        );

        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 
            'footer_link_hover_color', 
                array(
                    'label'      => esc_html__( 'Footer Link Hover Color', 'home-services' ),
                    'section'    => 'colors',
                    'settings'   => 'footer_link_hover_color',
                ) 
            ) 
        );
        $wp_customize->add_setting( 'footer_copyright_text', array(
            'transport' => 'refresh',
            'sanitize_callback'     =>  'wp_kses_post',
            'default'               =>  ''
        ) );

        $wp_customize->add_control( 'copyright_text', array(
            'label' => esc_html__( 'Copyright :', 'home-services' ),
            'section' => 'home_services_customize_register_footer_options_section',
            'settings' => 'footer_copyright_text',
            'type'=> 'textarea',
            'priority' => 4,
        ) );

        $wp_customize->selective_refresh->add_partial('footer_copyright_text', array(
            'selector' => 'footer .site-info', // You can also select a css class
        ));

        /*Mobile CTA Button*/
        $wp_customize->add_setting( 'mobile_cta_button_1', array(
        'sanitize_callback'     =>  'sanitize_text_field',
        'default'               =>  ''
        ) );

        $wp_customize->add_control( 'mobile_cta_button_1', array(
            'label' => esc_html__( 'Button 1', 'home-services' ),
            'description' => esc_html__('Button Text','home-services'),
            'section' => 'home_services_customize_register_mobile_cta',
            'settings' => 'mobile_cta_button_1',
            'type'=> 'text',
        ) );
     
        $wp_customize->add_setting( 'mobile_cta_button_1_link', array(
            'sanitize_callback'     =>  'esc_url_raw',
        ) );

        $wp_customize->add_control( 'mobile_cta_button_1_link', array(
            'label' =>'',
            'description' => esc_html__('Button Link','home-services'),
            'section' => 'home_services_customize_register_mobile_cta',
            'settings' => 'mobile_cta_button_1_link',
            'type'=> 'url',
        ) );

        $wp_customize->add_setting( 'mobile_cta_button_2', array(
        'sanitize_callback'     =>  'sanitize_text_field',
        'default'               =>  ''
        ) );

        $wp_customize->add_control( 'mobile_cta_button_2', array(
            'label' => esc_html__( 'Button 2', 'home-services' ),
            'description' => esc_html__('Button Text','home-services'),
            'section' => 'home_services_customize_register_mobile_cta',
            'settings' => 'mobile_cta_button_2',
            'type'=> 'text',
        ) );
     
        $wp_customize->add_setting( 'mobile_cta_button_2_link', array(
            'sanitize_callback'     =>  'esc_url_raw',
        ) );

        $wp_customize->add_control( 'mobile_cta_button_2_link', array(
            'label' =>'',
            'description' => esc_html__('Button Link','home-services'),
            'section' => 'home_services_customize_register_mobile_cta',
            'settings' => 'mobile_cta_button_2_link',
            'type'=> 'url',
        ) );
    }

}

