<?php
/**
 * Blog List Settings
 * 
 * @package home_services
 */


add_action( 'customize_register', 'home_services_customize_blog_option' );

function home_services_customize_blog_option( $wp_customize ) {
    $wp_customize->add_panel( 'home_service_blog_settings', 
        array(
            'priority'       => 17,
            'capability'     => 'edit_theme_options',
            'title'      =>  esc_html__('Blog Options', 'home-services'),
        ) 
    );

    $wp_customize->add_section( 'home_services_customize_blog_option', array(
        'title'          => esc_html__( 'Category Page', 'home-services' ),
        'priority'       => 1,
        'panel'          => 'home_service_blog_settings',  
    ) );

        $wp_customize->add_setting( 'blog_post_layout', array(
            'capability'  => 'edit_theme_options',        
            'sanitize_callback' => 'home_services_sanitize_choices',
            'default'     => 'sidebar-right',
        ) );
    
        $wp_customize->add_control( new Home_Services_Radio_Image_Control( $wp_customize, 'blog_post_layout', array(
            'label' => esc_html__( 'Sidebar Position', 'home-services' ),
            'section' => 'home_services_customize_blog_option',
            'settings' => 'blog_post_layout',
            'type'=> 'home-services-radio-image',
            'choices'     => array(
                'sidebar-left' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Left-Sidebar-Layout.png',
                'no-sidebar'    => get_template_directory_uri() . '/images/dashboard/blog-layouts/No-Sidebar-Layout.png',
                'sidebar-right' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Right-Sidebar-Layout.png',            
            ),
        ) ) );
        
        $wp_customize->add_setting( 'blog_post_view', array(
            'capability'  => 'edit_theme_options',     
            'sanitize_callback' => 'home_services_sanitize_choices',
            'default'     => 'grid-view',
        ) );
    
        $wp_customize->add_control( new Home_Services_Radio_Image_Control( $wp_customize, 'blog_post_view', array(
            'label' => esc_html__( 'Post Layout', 'home-services' ),
            'section' => 'home_services_customize_blog_option',
            'settings' => 'blog_post_view',
            'type'=> 'home-services-radio-image',
            'choices'     => array(
                'grid-view' => get_template_directory_uri() . '/images/dashboard/blog-layouts/grid-layout.png',
                'list-view' => get_template_directory_uri() . '/images/dashboard/blog-layouts/list-view.png',
                'full-width-view' => get_template_directory_uri() . '/images/dashboard/blog-layouts/full-width.png',
            ),
        ) ) );   

        $wp_customize->add_setting( 'hide_show_date', array(
            'sanitize_callback'     =>  'home_services_sanitize_checkbox',
            'default'               =>  true
        ) );
    
        $wp_customize->add_control( new Home_Services_Toggle_Control( $wp_customize, 'hide_show_date', array(
            'label' => esc_html__( 'Show Date','home-services' ),
            'section' => 'home_services_customize_blog_option',
            'settings' => 'hide_show_date',
            'type'=> 'home-services-toggle',
        ) ) );

        $wp_customize->add_setting( 'hide_show_author', array(
            'sanitize_callback'     =>  'home_services_sanitize_checkbox',
            'default'               =>  true
        ) );
    
        $wp_customize->add_control( new Home_Services_Toggle_Control( $wp_customize, 'hide_show_author', array(
            'label' => esc_html__( 'Show Author','home-services' ),
            'section' => 'home_services_customize_blog_option',
            'settings' => 'hide_show_author',
            'type'=> 'home-services-toggle',
        ) ) );

        $wp_customize->add_setting( 'hide_show_comment', array(
            'sanitize_callback'     =>  'home_services_sanitize_checkbox',
            'default'               =>  true
        ) );
    
        $wp_customize->add_control( new Home_Services_Toggle_Control( $wp_customize, 'hide_show_comment', array(
            'label' => esc_html__( 'Show Comment','home-services' ),
            'section' => 'home_services_customize_blog_option',
            'settings' => 'hide_show_comment',
            'type'=> 'home-services-toggle',
        ) ) );
        $wp_customize->add_setting( 'hide_show_category', array(
            'sanitize_callback'     =>  'home_services_sanitize_checkbox',
            'default'               =>  true
        ) );
    
        $wp_customize->add_control( new Home_Services_Toggle_Control( $wp_customize, 'hide_show_category', array(
            'label' => esc_html__( 'Show Category','home-services' ),
            'section' => 'home_services_customize_blog_option',
            'settings' => 'hide_show_category',
            'type'=> 'home-services-toggle',
        ) ) );
        $wp_customize->add_setting( 'hide_show_tags', array(
            'sanitize_callback'     =>  'home_services_sanitize_checkbox',
            'default'               =>  true
        ) );
    
        $wp_customize->add_control( new Home_Services_Toggle_Control( $wp_customize, 'hide_show_tags', array(
            'label' => esc_html__( 'Show Tags','home-services' ),
            'section' => 'home_services_customize_blog_option',
            'settings' => 'hide_show_tags',
            'type'=> 'home-services-toggle',
        ) ) );
        if( home_services_set_pro_active() ) {
            $wp_customize->add_section( 'home_services_customize_sidebar_options', array(
                'title'          => esc_html__( 'Mobile Sidebar', 'home-services' ),
                'priority'       => 4,
                'panel'          => 'home_service_mobile_optimization_settings',    
            ) );
            $wp_customize->add_setting( 'disable_sidebar_mobile', 
                array(
                  'default'  =>  false,
                  'sanitize_callback' => 'home_services_sanitize_checkbox'
                )
            );
            $wp_customize->add_control( new Home_Services_Toggle_Control( $wp_customize, 'disable_sidebar_mobile', 
                array(
                  'label'   => __( 'Disable Sidebar in Category Post', 'home-services' ),
                  'section' => 'home_services_customize_sidebar_options',
                  'settings' => 'disable_sidebar_mobile',
                  'type'    => 'home-services-toggle',
                )
            ));
        }

        

        /*single post page*/
        if( home_services_set_pro_active() ) {
            $wp_customize->add_section( 'home_services_customize_post_option', array(
            'title'          => esc_html__( 'Single Post', 'home-services' ),
            'priority'       => 2,
            'panel'          => 'home_service_blog_settings',  
            ) );
            $wp_customize->add_setting( 'single_blog_post_layout', array(
            'capability'  => 'edit_theme_options',        
            'sanitize_callback' => 'home_services_sanitize_choices',
            'default'     => 'single-sidebar-right',
            ) );
        
            $wp_customize->add_control( new Home_Services_Radio_Image_Control( $wp_customize, 'single_blog_post_layout', array(
                'label' => esc_html__( 'Sidebar Position', 'home-services' ),
                'section' => 'home_services_customize_post_option',
                'settings' => 'single_blog_post_layout',
                'type'=> 'home-services-radio-image',
                'choices'     => array(
                    'single-sidebar-left' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Left-Sidebar-Blog-Layout.png',
                    'single-no-sidebar'    => get_template_directory_uri() . '/images/dashboard/blog-layouts/No-Sidebar-Blog-Layout.png',
                    'single-sidebar-right' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Right-Sidebar-Blog-Layout.png',            
                ),
            ) ) );
            $wp_customize->add_setting( 'dingle_blog_page_layout', array(
                'capability'  => 'edit_theme_options',        
                'sanitize_callback' => 'home_services_sanitize_choices',
                'default'     => 'featured-image-after-title',
            ) );
        
            $wp_customize->add_control( new Home_Services_Radio_Image_Control( $wp_customize, 'dingle_blog_page_layout', array(
                'label' => esc_html__( 'Featured Image Position', 'home-services' ),
                'section' => 'home_services_customize_post_option',
                'settings' => 'dingle_blog_page_layout',
                'type'=> 'home-services-radio-image',
                'choices'     => array(
                    'featured-image-disabled' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Featured-Image-Disabled.png',
                    'featured-image-before-title'    => get_template_directory_uri() . '/images/dashboard/blog-layouts/Featured-Image-Before-Title.png',
                    'featured-image-after-title' => get_template_directory_uri() . '/images/dashboard/blog-layouts/Featured-Image-After-Title.png', 
                              
                ),
            ) ) );
                $wp_customize->add_setting( 'disable_single_sidebar_mobile', 
                    array(
                      'default'  =>  false,
                      'sanitize_callback' => 'home_services_sanitize_checkbox'
                    )
                );
                $wp_customize->add_control( new Home_Services_Toggle_Control( $wp_customize, 'disable_single_sidebar_mobile', 
                    array(
                      'label'   => __( 'Disable Sidebar in Single Post', 'home-services' ),
                      'section' => 'home_services_customize_sidebar_options',
                      'settings' => 'disable_single_sidebar_mobile',
                      'type'    => 'home-services-toggle',
                    )
                ));
                
                $wp_customize->add_setting( 'single_post_disable_related_post', 
                    array(
                      'default'  =>  true,
                      'sanitize_callback' => 'home_services_sanitize_checkbox'
                    )
                );
                $wp_customize->add_control( new Home_Services_Toggle_Control( $wp_customize, 'single_post_disable_related_post', 
                    array(
                      'label'   => __( 'Show Related Post', 'home-services' ),
                      'section' => 'home_services_customize_post_option',
                      'settings' => 'single_post_disable_related_post',
                      'type'    => 'home-services-toggle',
                    )
                ));
                $wp_customize->add_setting( 'single_post_disable_author_box', 
                    array(
                      'default'  =>  true,
                      'sanitize_callback' => 'home_services_sanitize_checkbox'
                    )
                );
                $wp_customize->add_control( new Home_Services_Toggle_Control( $wp_customize, 'single_post_disable_author_box', 
                    array(
                      'label'   => __( 'Show Author Box', 'home-services' ),
                      'section' => 'home_services_customize_post_option',
                      'settings' => 'single_post_disable_author_box',
                      'type'    => 'home-services-toggle',
                    )
                ));
        }


}