<?php 
// Exit if accessed directly.
if( class_exists( 'WP_Customize_control' ) ){
if( ! class_exists('Home_Services_Menu_Dropdown_Custom_Control') ):
    class Home_Services_Menu_Dropdown_Custom_Control extends WP_Customize_Control{
        
        public $type = 'home-services-custom-menu';

        private $menus = false;
        
        public function __construct($manager, $id, $args = array(), $options = array()){
            $this->menus = wp_get_nav_menus($options);

            parent::__construct( $manager, $id, $args );
        }

        /**
         * Render the content on the theme customizer page
        */
        public function render_content(){
            if(!empty($this->menus))
            {
                ?>
                    <label>
                        <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
                        <span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
                        <select <?php $this->link(); ?>>
                            <?php
                                printf('<option value="%s" %s>%s</option>', '', selected($this->value(), '', false),__('Select Menu', 'home-services') );
                             ?>
                        <?php
                            foreach ( $this->menus as $menu )
                            {
                                printf('<option value="%s" %s>%s</option>', $menu->term_id, selected($this->value(), $menu->term_id, false), $menu->name);
                            }
                        ?>
                        </select>
                    </label>
                <?php
            }
        }
    }
endif;
}