<?php

if(!home_services_check_activated_all_plugin()){
if( ! function_exists( 'home_services_admin_notice' ) ) :
/**
 * Adding Admin Notice for recommended plugins
 */
function home_services_admin_notice() {
    global $pagenow;
    $theme_args      = wp_get_theme();
    $name            = $theme_args->__get( 'Name' );
    $meta            = get_option( 'home-services-update-notice' );
    $current_screen  = get_current_screen();
    $advanded_import_install = file_exists(WP_PLUGIN_DIR . '/advanced-import/advanced-import.php' );
    $alley_toolkit_install = file_exists(WP_PLUGIN_DIR . '/alley-business-toolkit/alley-business-toolkit.php' );
    //$elementor_install = file_exists(WP_PLUGIN_DIR . '/elementor/elementor.php' );
    //$aew_install = file_exists(WP_PLUGIN_DIR . '/alley-elementor-widget/alley-elementor-widget.php' );
    $cf_install = file_exists(WP_PLUGIN_DIR . '/contact-form-7/wp-contact-form-7.php' );
    $htform_install = file_exists(WP_PLUGIN_DIR . '/ht-contactform/contact-form-widget-elementor.php' );

    
    if ( is_admin() && !$meta ) {
        
        // if( $current_screen->id !== 'dashboard' && $current_screen->id !== 'themes' ) {
        //     return;
        // }

        if ( is_network_admin() ) {
            return;
        }

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        } ?>

        <div class="notice notice-info is-dismissible content-install-plugin at-notice-layout">
            <div class="alley-icon">
                <img src="<?php echo esc_url(get_template_directory_uri() . '/inc/admin/image/logo.png'); ?>" />
            </div>
             <div class="notice-content">
                <h3><?php echo __('Install & Activate Recommended Plugins','home-services');?></h3>
                <!-- plugins list need to be install -->
                     <h4><?php echo __('We recommend you to install and Activate the following plugins for the Home Services Theme to work as desired:','home-services');?></h4>
                     <p>
                        <?php 
                        $install_label_advanced_import='';
                        $install_label_abt = '';
                        $install_label_aew='';
                        $install_label_cfs='';
                        $install_label_htf='';
                        $install_label_elementor='';
                        if(!$advanded_import_install){
                            $install_label_advanced_import= __('Advanced Import','home-services');
                        }
                        ?>
                        <?php 
                        if(!$alley_toolkit_install){
                           $install_label_abt= __('Alley Business Toolkit','home-services');
                        }
                        ?>
                        <?php 
                         /*if(!$aew_install){
                            $install_label_aew = __('Alley Elementor Widget','home-services');
                        }*/
                        ?>
                        <?php 
                        if(!$cf_install){
                            $install_label_cfs = __('Contact Form 7','home-services');
                        }
                        ?>
                        <?php
                        /*if(!$htform_install){
                           $install_label_htf =__('Contact Form 7 Widget For Elementor Page Builder','home-services');
                        }*/
                        ?>
                        <?php 
                        /*if(!$elementor_install){
                            $install_label_elementor =__('Elementor','home-services');
                        }*/
                        $install_plugin_list_array = array($install_label_advanced_import,$install_label_abt,$install_label_aew,$install_label_cfs,$install_label_htf,$install_label_elementor);
                        $filter_install_pluign_array = array_filter($install_plugin_list_array);
                        $installed_pluign_list = implode(', ', $filter_install_pluign_array);
                        if(!empty($filter_install_pluign_array) ){?>
                            <strong><?php echo __('The following plugins needs to be install:','home-services');?></strong> 
                        <?php }
                         echo join(' and ', array_filter(array_merge(array(join(', ', array_slice($filter_install_pluign_array, 0, -1))), array_slice($filter_install_pluign_array, -1)), 'strlen'));
                        ?></p>

                <!--pluign list need to activated -->

                 
                <p>
                    <?php 
                        $label_advanced_import='';
                        $label_abt = '';
                        $label_aew='';
                        $label_cfs='';
                        $label_htf='';
                        $label_elementor='';
                        if(home_services_advanced_import_active_status()){
                           $label_advanced_import = __('Advanced Import','home-services');
                        }
                        ?>
                        <?php 
                        if(home_services_alley_toolkit_active_status()){
                            $label_abt = __('Alley Business Toolkit','home-services');
                        }
                        ?>
                        <?php 
                         if(home_services_aew_active_status()){
                             $label_aew = __('Alley Elementor Widget','home-services');
                        }
                        ?>
                        <?php 
                        if(home_services_cfs_active_status()){
                            $label_cfs = __('Contact Form 7','home-services');
                        }
                        ?>
                        <?php
                        if(home_services_htform_active_status()){
                            $label_htf = __('Contact Form 7 Widget For Elementor Page Builder','home-services');
                        }
                        ?>
                        <?php 
                        if(home_services_elementor_active_status()){
                            $label_elementor =  __('Elementor','home-services');
                        }
                        $active_plugin_list_array = array($label_advanced_import,$label_abt,$label_aew,$label_cfs,$label_htf,$label_elementor);
                        $filter_active_pluign_array = array_filter($active_plugin_list_array);
                        $activated_pluign_list = implode(', ', $filter_active_pluign_array);
                        if(!empty($filter_active_pluign_array) ){?>
                            <strong><?php echo __('The following plugins needs to be activate:','home-services');?></strong> 
                        <?php }
                        echo join(' and ', array_filter(array_merge(array(join(', ', array_slice($filter_active_pluign_array, 0, -1))), array_slice($filter_active_pluign_array, -1)), 'strlen'));
                        ?></p>
                </p>

                
                <?php if(home_services_plugins_installed() == false){?>
                    
                    <a href="<?php echo admin_url();?>themes.php?page=tgmpa-install-plugins&plugin_status=install" class="hs-admin-button install-button"><?php echo __('Install Plugins','home-services');?></a>
                <?php }
                
                if(home_services_check_activated_plugin() == false){?>
                    <a href="<?php echo admin_url();?>themes.php?page=tgmpa-install-plugins&plugin_status=activate" class="hs-admin-button activate-button"><?php echo __('Activate Plugins','home-services');?></a>
                    <?php 
                } ?>
                <a href="<?php echo admin_url();?>/themes.php?home-services-update-notice=true" class="dismiss-notice hs-admin-button dismiss-button btn-install-plugin"><?php echo __('No Thanks','home-services');?></a>
            </div>
         </div>
    <?php }
}
endif;
add_action( 'admin_notices', 'home_services_admin_notice' );

if( ! function_exists( 'home_services_ignore_admin_notice' ) ) :
/**
 * ignore notice if dismissed!
 */
function home_services_ignore_admin_notice() {

    if ( isset( $_GET['home-services-update-notice'] ) && $_GET['home-services-update-notice'] = 'true' ) {

        update_option( 'home-services-update-notice', true );
    }
}
endif;
add_action( 'admin_init', 'home_services_ignore_admin_notice' );

if ( ! function_exists( 'is_plugin_active' ) ){
 require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
}

// $abt_path_url = ;
function home_services_plugins_installed(){
    $home_services_plugins_installed_status = false;
    $advanded_import_install = file_exists(WP_PLUGIN_DIR . '/advanced-import/advanced-import.php' );
    $alley_toolkit_install = file_exists(WP_PLUGIN_DIR . '/alley-business-toolkit/alley-business-toolkit.php' );
    $elementor_install = file_exists(WP_PLUGIN_DIR . '/elementor/elementor.php' );
    $aew_install = file_exists(WP_PLUGIN_DIR . '/alley-elementor-widget/alley-elementor-widget.php' );
    $cf_install = file_exists(WP_PLUGIN_DIR . '/contact-form-7/wp-contact-form-7.php' );
   // $htform_install = file_exists(WP_PLUGIN_DIR . '/ht-contactform/contact-form-widget-elementor.php' );
    if($advanded_import_install && $alley_toolkit_install && $elementor_install && $aew_install && $cf_install){
         $home_services_plugins_installed_status = true;
    }
    return $home_services_plugins_installed_status;
}
function home_services_check_activated_plugin(){
    $home_services_plugins_activated = true;
    if( home_services_advanced_import_active_status() ||  home_services_alley_toolkit_active_status() ||home_services_elementor_active_status() || home_services_aew_active_status() || home_services_cfs_active_status() || home_services_htform_active_status() ){
        $home_services_plugins_activated = false;
    }
    return $home_services_plugins_activated;
}

function home_services_advanced_import_active_status(){
    $advanded_import_activate_status = false;
    $advanded_import_install = file_exists(WP_PLUGIN_DIR . '/advanced-import/advanced-import.php' );
    $advanded_import_activated = is_plugin_active ( 'advanced-import/advanced-import.php' );
    if($advanded_import_install &&  ! $advanded_import_activated){
        $advanded_import_activate_status = true;
    }
    return $advanded_import_activate_status;
}
function home_services_alley_toolkit_active_status(){
    $alley_toolkit_activate_status = false;
    $alley_toolkit_install = file_exists(WP_PLUGIN_DIR . '/alley-business-toolkit/alley-business-toolkit.php' );
    $alley_toolkit_activated = is_plugin_active ( 'alley-business-toolkit/alley-business-toolkit.php' );
    if($alley_toolkit_install &&  !$alley_toolkit_activated){
        $alley_toolkit_activate_status = true;
    }
    return $alley_toolkit_activate_status;
}
function home_services_elementor_active_status(){
    $elementor_activate_status = false;
    $elementor_install = file_exists(WP_PLUGIN_DIR . '/elementor/elementor.php' );
    $elementor_activated = is_plugin_active ( 'elementor/elementor.php' );
    if($elementor_install &&  !$elementor_activated){
        $elementor_activate_status = true;
    }
    return $elementor_activate_status;
}
function home_services_aew_active_status(){
    $aew_activate_status = false;
    $aew_install = file_exists(WP_PLUGIN_DIR . '/alley-elementor-widget/alley-elementor-widget.php' );
    $aew_activated = is_plugin_active ( 'alley-elementor-widget/alley-elementor-widget.php' );
    if($aew_install &&  !$aew_activated){
        $aew_activate_status = true;
    }
    return $aew_activate_status;
}
function home_services_cfs_active_status(){
    $cf_activate_status = false;
    $cf_install = file_exists(WP_PLUGIN_DIR . '/contact-form-7/wp-contact-form-7.php' );
    $cf_activated = is_plugin_active ( 'contact-form-7/wp-contact-form-7.php' );
    if($cf_install &&  !$cf_activated){
        $cf_activate_status = true;
    }
    return $cf_activate_status;
}
function home_services_htform_active_status(){
    $htform_activate_status = false;
    $htform_install = file_exists(WP_PLUGIN_DIR . '/ht-contactform/contact-form-widget-elementor.php' );
    $htform_activated = is_plugin_active ( 'ht-contactform/contact-form-widget-elementor.php' );
    if($htform_install &&  !$htform_activated){
        $htform_activate_status = true;
    }
    return $htform_activate_status;
}


}

function home_services_check_activated_all_plugin(){
    if ( ! function_exists( 'is_plugin_active' ) ){
        require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
    }
    $home_services_plugins_activated_status = false;
    $advanded_import_activated = is_plugin_active ( 'advanced-import/advanced-import.php' );
    $alley_toolkit_activated = is_plugin_active ( 'alley-business-toolkit/alley-business-toolkit.php' );
    $alley_toolkit_pro_activated = is_plugin_active ( 'alley-business-toolkit-pro/alley-business-toolkit.php' );
    $elementor_activated = is_plugin_active ( 'elementor/elementor.php' );
    $aew_activated = is_plugin_active ( 'alley-elementor-widget/alley-elementor-widget.php' );
    $cf_activated = is_plugin_active ( 'contact-form-7/wp-contact-form-7.php' );
    //$htform_activated = is_plugin_active ( 'ht-contactform/contact-form-widget-elementor.php' );
    if($advanded_import_activated && ($alley_toolkit_activated || $alley_toolkit_pro_activated) && $cf_activated){
        $home_services_plugins_activated_status = true;
    }
    return $home_services_plugins_activated_status;
}