<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package home_services
 */

get_header();
?>

<div class="inside-page author-page">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <main id="primary" class="site-main">
                    <div class="author-info-box">
                        <?php
                            $current_author = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author));
                            $author_img = get_avatar_url($current_author->ID, ['size' => '350']);
                            if($author_img){ ?>
                                <div class="col-sm-4">
                                        <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>">
                                        <img src="<?php echo $author_img; ?>" title="<?php echo get_the_author(); ?>">
                                    </img></a>
                                </div>
                            <?php } ?>
                        <div class="col-sm-8">
                            <h3><?php echo $current_author->first_name .' ' .$current_author->last_name; ?></h3>
                           <?php
                           $author_details= $current_author->user_description;
                           if($author_details){?>
                             <p class="author-details"><?php echo $author_details; ?></p>
                           <?php } ?>
                        </div>
                    </div>
                    <!-- The Loop -->
                    <div class="col-sm-12 author-related-post">
                         
                         <div class="grid-view">
                        <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                            <article class="artilce-by-author">
                              
                                    <?php if ( has_post_thumbnail() ) : ?>
                                            <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark" class="featured-image">
                                             <?php the_post_thumbnail( 'home_services_feature_image' ); ?>
                                        </a>
                                     <?php endif; ?>
                                <div class="entry-meta category">
                                    <?php
                                        $categories = get_the_category();
                                      if( ! empty( $categories ) ) :
                                        foreach ( $categories as $category ) { ?>
                                            <span class="post-meta author-categories"><a
                                                href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><?php echo esc_html( $category->name ); ?></a>
                                            </span>
                                            <?php }
                                     endif; 
                                    ?>
                                </div>
                                <h4 class="news-title"><a href="<?php echo esc_url( get_permalink() ); ?>"
                                        rel="bookmark"><?php the_title(); ?></a>
                                </h4>
                                <div class="entry-meta">
                                <?php
                                echo  '<span class="post-meta author-author">';
                                    home_services_posted_by();
                                echo '</span>';
                                
                                         $archive_year  = get_the_time('Y'); $archive_month = get_the_time('m'); $archive_day = get_the_time('d'); ?>
                                        <span class="post-meta author-post-date"> <a
                                                href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>"><?php echo get_the_date(); ?></a>
                                        </span>
                                        <span class="post-meta author-comment">
                                                <?php comments_popup_link( __( 'Leave a comment', 'home-services' ), __( '1 comment', 'home-services' ), __( '% comments', 'home-services' ) ); ?>
                                        </span>
                                        
                                      <?php $tags = get_the_tags($post->ID);
                                        if( ! empty( $tags ) ) :
                                            foreach ( $tags as $post_tag ) { ?>
                                                <span class="post-meta author-tag"><i class="fa fa-tag" aria-hidden="true"></i> <a
                                                            href="<?php echo esc_url( get_category_link( $post_tag->term_id ) ); ?>"><?php echo esc_html( $post_tag->name ); ?></a>
                                                </span>
                                         <?php }
                                     endif;
                                        ?>
                            </div><!-- .entry-meta -->
                                 <p><?php echo esc_html(home_services_excerpt( 18 )); ?></p>
                                 <a href="<?php echo the_permalink();?>" class="btn-more"><?php echo __('Read More','home-services'); ?> &#8594;</a>
                               




                            </article>
                        

                    <?php endwhile; ?>
                    
                  <?php
                    // global $wp_query; // you can remove this line if everything works for you
                     if (  $wp_query->max_num_pages > 1 )
                        echo '<div class="post_loadmore">'.__('Load More','home-services').'</div>'; // you can use <a> as well
                    ?>
                        <?php else: ?>

                            <p><?php _e('No posts by this author.','home-services'); ?></p>

                        <?php endif; ?>

                    <!-- End Loop -->
                    </div>
                      </div>


                   
                </main><!-- #main -->
            </div>
        </div>
    </div>
</div>

<?php


get_footer();
